<?php

class nixmoneyPayment extends waPayment implements waIPayment
{
    const VERSION = '1.0';

    protected function initControls(){}

    public function allowedCurrency()
	{
        return array(
            'USD',
            'EUR',
        ); 
    }

    public function payment($payment_form_data, $order_data, $auto_submit = false)
	{
		$email_error = $this->email_error;
		
		$ip_filter = $this->ip_filter;
		
        $order = waOrder::factory($order_data);

		$m_url = $this->m_url;
		
        $m_shop = $this->m_shop;
		
		$m_key = $this->m_key;

        $m_orderid = $order->id;

        $m_amount = number_format($order->total, 2, '.', '');

        $m_curr = $order->currency;

        $m_desc = $this->m_desc . ' (' . $this->app_id . '-' . $this->merchant_id . ')';
		
		$status_url = 'http://'. $_SERVER['HTTP_HOST'].'/payments.php/nixmoney/?action=status';
		$payment_url = 'http://'. $_SERVER['HTTP_HOST'].'/payments.php/nixmoney/?action=success';
		$nopayment_url = 'http://'. $_SERVER['HTTP_HOST'].'/payments.php/nixmoney/?action=fail';
		$m_orderid2 = time().$m_orderid;
		
        $view = wa()->getView();
		$view->assign('m_url', $m_url);
		$view->assign('m_shop', $m_shop);
        $view->assign('m_orderid', $m_orderid);
        $view->assign('m_orderid2', $m_orderid2);
		$view->assign('m_amount', $m_amount);
		$view->assign('m_curr', $m_curr);
		$view->assign('m_desc', $m_desc);
        $view->assign('status_url', $status_url);
        $view->assign('payment_url', $payment_url);
        $view->assign('nopayment_url', $payment_url);
        $view->assign('auto_submit', $auto_submit);
		
		return $view->fetch($this->path . '/templates/nixmoney.html');
    }

    protected function callbackInit($request)
	{
		$desc = base64_decode($request['m_desc']);
		preg_match_all("/\(+.+\-+[0-9]+\)+/", $desc, $matches);
		preg_match('/\((.+)\)/', $matches[0][0], $m);
		$opt = explode('-', $m[1]);
		
		$this->app_id = $opt[0]; 
		$this->merchant_id = $opt[1];
        return parent::callbackInit($request);
    }

    public function callbackHandler($request)
	{	
		$transaction_data = $this->formalizeData($request);
        $action = $request['action'];
        $url = null;
        $app_payment_method = null;
			
        switch ($action) 
		{
            case 'status':
			
				if (isset($request['V2_HASH']))
				{
					$m_key = $this->m_key;
					 $string=
 $_POST['PAYMENT_ID'].':'.$_POST['PAYEE_ACCOUNT'].':'.$_POST['PAYMENT_AMOUNT'].':'.$_POST['PAYMENT_UNITS'].':'.
 $_POST['PAYMENT_BATCH_NUM'].':'.$_POST['PAYER_ACCOUNT'].':'.strtoupper(md5($m_key)).':'.$_POST['TIMESTAMPGMT'];

 $v2key=$_POST['V2_HASH'];
 $sign_hash=strtoupper(md5($string));
					
					// проверка принадлежности ip списку доверенных ip
					
					$list_ip_str = str_replace(' ', '', $this->ip_filter);
					
					if (!empty($list_ip_str)) 
					{
						$list_ip = explode(',', $list_ip_str);
						$this_ip = $_SERVER['REMOTE_ADDR'];
						$this_ip_field = explode('.', $this_ip);
						$list_ip_field = array();
						$i = 0;
						$valid_ip = FALSE;
						foreach ($list_ip as $ip)
						{
							$ip_field[$i] = explode('.', $ip);
							if ((($this_ip_field[0] ==  $ip_field[$i][0]) or ($ip_field[$i][0] == '*')) and
								(($this_ip_field[1] ==  $ip_field[$i][1]) or ($ip_field[$i][1] == '*')) and
								(($this_ip_field[2] ==  $ip_field[$i][2]) or ($ip_field[$i][2] == '*')) and
								(($this_ip_field[3] ==  $ip_field[$i][3]) or ($ip_field[$i][3] == '*')))
								{
									$valid_ip = TRUE;
									break;
								}
							$i++;
						}
					}
					else
					{
						$valid_ip = TRUE;
					}
					
					$log_text =
					 "--------------------------------------------------------\n".
					 "PAYMENT_ID " . $_POST["PAYMENT_ID"] . "\n".
					 "PAYEE_ACCOUNT " . $_POST["PAYEE_ACCOUNT"] . "\n".
					 "PAYMENT_AMOUNT " . $_POST["PAYMENT_AMOUNT"] . "\n".
					 "PAYMENT_UNITS " . $_POST["PAYMENT_UNITS"] . "\n".
					 "PAYMENT_BATCH_NUM " . $_POST["PAYMENT_BATCH_NUM"] . "\n".
					 "PAYER_ACCOUNT " . $_POST["PAYER_ACCOUNT"] . "\n".
					 "V2_HASH " . $_POST["V2_HASH"] . "\n";
						
					if (!empty($this->log_file))
					{
						file_put_contents($_SERVER['DOCUMENT_ROOT'] . $this->log_file, $log_text, FILE_APPEND);
					}
		
					if ($request['V2_HASH'] == $sign_hash && $valid_ip)
					{
						$callback_method = self::CALLBACK_PAYMENT;
						$transaction_data = $this->saveTransaction($transaction_data, $request);
						$callback = $this->execAppCallback($callback_method, $transaction_data);
						self::addTransactionData($transaction_data['id'], $callback);
				
						exit ('success');
					}
					else
					{
						$callback_method = self::CALLBACK_DECLINE;
						$transaction_data = $this->saveTransaction($transaction_data, $request);
						$callback = $this->execAppCallback($callback_method, $transaction_data);
						self::addTransactionData($transaction_data['id'], $callback);
				
						$to = $this->email_error;
						$subject = "Ошибка оплаты";
						$message = "Не удалось провести платёж через систему nixmoney по следующим причинам:\n\n";
						
						if ($request["V2_HASH"] != $sign_hash)
						{
							$message .= " - Не совпадают цифровые подписи\n";
						}
						
						if (!$valid_ip)
						{
							$message .= " - ip-адрес сервера не является доверенным\n";
							$message .= "   доверенные ip: " . $this->ip_filter . "\n";
							$message .= "   ip текущего сервера: " . $_SERVER['REMOTE_ADDR'] . "\n";
						}
						
						$message .= "\n" . $log_text;
						$headers = "From: no-reply@" . $_SERVER['HTTP_SERVER'] . "\r\nContent-type: text/plain; charset=utf-8 \r\n";
						mail($to, $subject, $message, $headers);
						
						exit ('error');
					}
				}
                break;

            case 'success':
				$url = $this->getAdapter()->getBackUrl(waAppPayment::URL_SUCCESS, $transaction_data);
				return array('redirect' => $url);
				break;
				
            case 'fail':
				$url = $this->getAdapter()->getBackUrl(waAppPayment::URL_FAIL, $transaction_data);
				return array('redirect' => $url);
				break;
        }
    }

    protected function formalizeData($transaction_raw_data)
	{
        $transaction_data = parent::formalizeData($transaction_raw_data);

        $transaction_data['native_id'] = $transaction_raw_data['PAYMENT_ID'];

        $transaction_data['amount'] = $transaction_raw_data['PAYMENT_AMOUNT'];

        $transaction_data['currency_id'] = $transaction_raw_data['PAYMENT_UNITS'];

        $transaction_data['order_id'] = $transaction_raw_data['PAYMENT_ID'];
		

        switch ($transaction_raw_data['action'])
		{
            case 'success':
                $transaction_data['state'] = self::STATE_CAPTURED;
                $transaction_data['type'] = self::OPERATION_AUTH_CAPTURE;
                $transaction_data['result'] = 1;
                break;
				
            case 'fail':
                $transaction_data['state'] = self::STATE_DECLINED;
                $transaction_data['type'] = self::OPERATION_CANCEL;
                $transaction_data['result'] = 1;
                break;
        }
		
        return $transaction_data;
    }
	
}