<?php

//define('LOG_PM_STATUS', true);

chdir ('../../');
if(defined('LOG_PM_STATUS')) $f=fopen('log.txt', 'ab');
require_once('api/Simpla.php');
$simpla = new Simpla();

$order = $simpla->orders->get_order(intval($_POST['PAYMENT_ID']));
if(empty($order)){
	if(defined('LOG_PM_STATUS')) fwrite($f, 'Order not found: '.serialize($_POST)."\n");
	if(defined('LOG_PM_STATUS')) fclose($f);
	die('Order not found');
}

$method = $simpla->payment->get_payment_method(intval($order->payment_method_id));
if(empty($method)){
	if(defined('LOG_PM_STATUS')) fwrite($f, 'Unknown payment method: '.serialize($_POST)."\n");
	if(defined('LOG_PM_STATUS')) fclose($f);
	die("Unknown payment method");
}
	
$settings = unserialize($method->settings);
$payment_currency = $simpla->money->get_currency(intval($method->currency_id));

if($settings['nixmoney_payee_account'] !== $_POST['PAYEE_ACCOUNT']){
	if(defined('LOG_PM_STATUS')) fwrite($f, 'bad payee account: '.serialize($_POST)."\n");
	if(defined('LOG_PM_STATUS')) fclose($f);
	die('bad payee account');
}

$string=
	$_POST['PAYMENT_ID'].':'.$_POST['PAYEE_ACCOUNT'].':'.
	$_POST['PAYMENT_AMOUNT'].':'.$_POST['PAYMENT_UNITS'].':'.
	$_POST['PAYMENT_BATCH_NUM'].':'.
	$_POST['PAYER_ACCOUNT'].':'.strtoupper(md5(trim($settings['nixmoney_alternate_passphrase']))).':'.
	$_POST['TIMESTAMPGMT'];

$hash=strtoupper(md5($string));

if($hash!=$_POST['V2_HASH']){
	if(defined('LOG_PM_STATUS')) fwrite($f, 'bad hash (our: '.$hash.' vs. '.$_POST['V2_HASH'].'): '.serialize($_POST)."\n");
	if(defined('LOG_PM_STATUS')) fclose($f);
	die('bad hash');
}

if($order->paid){
	if(defined('LOG_PM_STATUS')) fwrite($f, 'bad hash ('.$_POST['PAYMENT_ID'].')'."\n");
	if(defined('LOG_PM_STATUS')) fclose($f);
	die('Order already paid');
}

if($_POST['PAYMENT_AMOUNT'] != round($simpla->money->convert($order->total_price, $method->currency_id, false), 2) || $_POST['PAYMENT_AMOUNT']<=0){
	if(defined('LOG_PM_STATUS')) fwrite($f, 'incorrect price (our: '.round($simpla->money->convert($order->total_price, $method->currency_id, false), 2).' vs. '.$_POST['PAYMENT_AMOUNT'].'): '.serialize($_POST)."\n");
	if(defined('LOG_PM_STATUS')) fclose($f);
	die("incorrect price");
}

$simpla->orders->update_order(intval($order->id), array('paid'=>1));

$simpla->notify->email_order_user(intval($order->id));
$simpla->notify->email_order_admin(intval($order->id));

$simpla->orders->close(intval($order->id));


exit();
