<?php

defined('_JEXEC') or die('Restricted access');

if (!class_exists('vmPSPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

class plgVmPaymentNixMoney extends vmPSPlugin {

	function __construct(& $subject, $config) {

		parent::__construct($subject, $config);

		$this->_loggable = TRUE;
		$this->_tablepkey = 'id'; //virtuemart_nixmoney_id';
		$this->_tableId = 'id'; //'virtuemart_nixmoney_id';
		$varsToPush = array(
			'debug' => array(0, 'int'),
			'nixmoney_payee_account' => array('', 'char'),
			'nixmoney_payee_name' => array('', 'char'),
			'nixmoney_alternate_passphrase' => array('', 'char')
		);

		$this->setConfigParameterable($this->_configTableFieldName, $varsToPush);

	}

	/**
	 * @return string
	 */
	public function getVmPluginCreateTableSQL() {

		return false;
	}

	/**
	 * @return array
	 */
	function getTableSQLFields() {

		$SQLfields = array();
		return $SQLfields;
	}

	/**
	 * @param $cart
	 * @param $order
	 * @return bool|null
	 */
	function plgVmConfirmedOrder($cart, $order) {

		if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement($method->payment_element)) {
			return FALSE;
		}
		$session = JFactory::getSession();
		$return_context = $session->getId();
		$this->_debug = $method->debug;
		$this->logInfo('plgVmConfirmedOrder order number: ' . $order['details']['BT']->order_number, 'message');

		if (!class_exists('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		if (!class_exists('VirtueMartModelCurrency')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');
		}

		$address = ((isset($order['details']['ST'])) ? $order['details']['ST'] : $order['details']['BT']);

		if (!class_exists('TableVendors')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'tables' . DS . 'vendors.php');
		}
		$vendorModel = VmModel::getModel('Vendor');
		$vendorModel->setId(1);
		$vendor = $vendorModel->getVendor();
		$vendorModel->addImages($vendor, 1);
		$this->getPaymentCurrency($method);
		$email_currency = $this->getEmailCurrency($method);
		$currency_code_3 = shopFunctions::getCurrencyByID($method->payment_currency, 'currency_code_3');

		$totalInPaymentCurrency = vmPSPlugin::getAmountInCurrency($order['details']['BT']->order_total,$method->payment_currency);
		$cd = CurrencyDisplay::getInstance($cart->pricesCurrency);
		if ($totalInPaymentCurrency <= 0) {
			vmInfo(JText::_('Incorrect payment amount'));
			return FALSE;
		}

		$quantity = 0;
		foreach ($cart->products as $key => $product) {
			$quantity = $quantity + $product->quantity;
		}

		// check currency
		switch(strtoupper(substr($method->nixmoney_payee_account, 0, 1))){
		case 'U':
			$pm_currency='USD';
		break;
		case 'E':
			$pm_currency='EUR';
		break;
		default:
			vmInfo(JText::_('Incorrect NixMoney payee account'));
			return FALSE;
		break;
		}

		// add spin image
		$html = '<html><head><title>Redirection</title></head><body><div style="margin: auto; text-align: center;">';
		$html .= '<form action="' . 'https://dev.nixmoney.com/merchant.jsp" method="post" name="vm_nixmoney_form"  accept-charset="UTF-8">';
		$html .= '<input type="submit"  value="' . JText::_('Redirecting to NixMoney payment gateway...') . '" />';
		$html .= '<input type="hidden" name="SUGGESTED_MEMO" value="'.$order['details']['BT']->order_number.'">
<input type="hidden" name="PAYMENT_ID" value="'.time().$order['details']['BT']->order_number.'" />
<input type="hidden" name="PAYMENT_AMOUNT" value="'.$totalInPaymentCurrency['value'].'" />
<input type="hidden" name="PAYEE_ACCOUNT" value="'.$method->nixmoney_payee_account.'" />
<input type="hidden" name="PAYMENT_UNITS" value="'.$pm_currency.'" />
<input type="hidden" name="PAYEE_NAME" value="'.JText::_('Payment for order') . ': ' . $order['details']['BT']->order_number.'" />
<input type="hidden" name="PAYMENT_URL" value="'. substr(JURI::root(false,''),0,-1) . JROUTE::_( 'index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&on=' . $order['details']['BT']->order_number . '&pm=' . $order['details']['BT']->virtuemart_paymentmethod_id . '&Itemid=' . JRequest::getInt('Itemid'), false).'" />
<input type="hidden" name="PAYMENT_URL_METHOD" value="LINK" />
<input type="hidden" name="NOPAYMENT_URL" value="'.substr(JURI::root(false,''),0,-1). JROUTE::_( 'index.php?option=com_virtuemart&view=pluginresponse&task=pluginUserPaymentCancel&on=' . $order['details']['BT']->order_number . '&pm=' . $order['details']['BT']->virtuemart_paymentmethod_id . '&Itemid=' . JRequest::getInt('Itemid'), false).'" />
<input type="hidden" name="NOPAYMENT_URL_METHOD" value="LINK" />
<input type="hidden" name="STATUS_URL" value="'.substr(JURI::root(false,''),0,-1) . JROUTE::_('index.php?option=com_virtuemart&view=pluginresponse&task=pluginnotification&tmpl=component', false).'" />
<input type="hidden" name="BAGGAGE_FIELDS" value="SUGGESTED_MEMO" />
<input type="hidden" name="custom" value="'.$return_context.'" />

</form></div>';
		$html .= ' <script type="text/javascript">';
		$html .= ' document.vm_nixmoney_form.submit();';
		$html .= ' </script></body></html>';

		// 	2 = don't delete the cart, don't send email and don't redirect
		$cart->_confirmDone = FALSE;
		$cart->_dataValidated = FALSE;
		$cart->setCartIntoSession();
		JRequest::setVar('html', $html);


	}

	/**
	 * @param $virtuemart_paymentmethod_id
	 * @param $paymentCurrencyId
	 * @return bool|null
	 */
	function plgVmgetPaymentCurrency($virtuemart_paymentmethod_id, &$paymentCurrencyId) {

		if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement($method->payment_element)) {
			return FALSE;
		}
		$this->getPaymentCurrency($method);
		$paymentCurrencyId = $method->payment_currency;
	}

	/**
	 * @param $virtuemart_paymentmethod_id
	 * @param $paymentCurrencyId
	 * @return bool|null
	 */
	function plgVmgetEmailCurrency($virtuemart_paymentmethod_id, $virtuemart_order_id, &$emailCurrencyId) {


	}

	/**
	 * @param $html
	 * @return bool|null|string
	 */
	function plgVmOnPaymentResponseReceived(&$html) {

		if (!class_exists('VirtueMartCart')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
		}
		if (!class_exists('shopFunctionsF')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
		}
		if (!class_exists('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}

		//We delete the old stuff
		// get the correct cart / session
		$cart = VirtueMartCart::getCart();
		$cart->emptyCart();
		return TRUE;
	}

	/**
	 * @return bool|null
	 */
	function plgVmOnUserPaymentCancel() {

		return TRUE;
	}

	/** @return bool|null
	 */
	function plgVmOnPaymentNotification() {

		//$this->_debug = true;
		if (!class_exists('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		$nixmoney_data = JRequest::get('post');
		if (!isset($nixmoney_data['PAYMENT_ID'])) {
			return FALSE;
		}

		$order_number = $nixmoney_data['PAYMENT_ID'];
		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($nixmoney_data['PAYMENT_ID']))) {
			return FALSE;
		}


			$db = JFactory::getDBO ();
			$q = 'SELECT * FROM `#__virtuemart_orders` '
				. 'WHERE `virtuemart_order_id` = '.$virtuemart_order_id;

			$db->setQuery ($q);
			$payments = $db->loadObject();

			//print_r($payments);

			$payments->order_total=round($payments->order_total, 2);

			if($payments->order_total<0.01){
				$this->_debug = $method->debug;
				$this->logInfo("STATUS_URL FAIL: REASON: can not load ORDER; POST: ".serialize($nixmoney_data)."; STRING: $string; HASH: $hash", 'message');
			}

		$method = $this->getVmPluginMethod($payments->virtuemart_paymentmethod_id);

		if (!$this->selectedThisElement($method->payment_element)) {
			return FALSE;
		}

		$this->_debug = $method->debug;

		//$this->_storeNixMoneyInternalData ($method, $nixmoney_data, $virtuemart_order_id, $payment->virtuemart_paymentmethod_id);
		$modelOrder = VmModel::getModel('orders');
		$order = array();

		$lang = JFactory::getLanguage();
		$order['customer_notified'] = 1;

		define('ALTERNATE_PHRASE_HASH', strtoupper(md5($method->nixmoney_alternate_passphrase)));

		$string=
			  $_POST['PAYMENT_ID'].':'.$_POST['PAYEE_ACCOUNT'].':'.
			  $_POST['PAYMENT_AMOUNT'].':'.$_POST['PAYMENT_UNITS'].':'.
			  $_POST['PAYMENT_BATCH_NUM'].':'.
			  $_POST['PAYER_ACCOUNT'].':'.ALTERNATE_PHRASE_HASH.':'.
			  $_POST['TIMESTAMPGMT'];

		$hash=strtoupper(md5($string));

		if($hash==$_POST['V2_HASH']){ // proccessing payment if only hash is valid
			
			if($_POST['PAYMENT_AMOUNT']==$payments->order_total && $_POST['PAYEE_ACCOUNT']==$method->nixmoney_payee_account){
				
				$this->logInfo("STATUS_URL SUCCESS: POST: ".serialize($nixmoney_data)."; STRING: $string; HASH: $hash", 'message');

				$order['order_status']='C';

				$this->logInfo('plgVmOnPaymentNotification return new_status:' . $order['order_status'], 'message');

				$modelOrder->updateStatusForOneOrder($virtuemart_order_id, $order, TRUE);
				//// remove vmcart
				if (isset($nixmoney_data['custom'])) {
					$this->emptyCart($nixmoney_data['custom'], $order_number);
				}

		   }else{ // you can also save invalid payments for debug purposes

			  $this->logInfo("STATUS_URL FAIL: REASON: fake data; POST: ".serialize($nixmoney_data)."; STRING: $string; HASH: $hash", 'message');
			  
		   }


		}else{ // you can also save invalid payments for debug purposes
	   
			$this->logInfo("STATUS_URL FAIL: REASON: bad hash; POST: ".serialize($nixmoney_data)."; STRING: $string; HASH: $hash", 'message');

		}

		die('done');
	}

	/**
	 * Display stored payment data for an order
	 *
	 * @see components/com_virtuemart/helpers/vmPSPlugin::plgVmOnShowOrderBEPayment()
	 */
	function plgVmOnShowOrderBEPayment($virtuemart_order_id, $payment_method_id) {

		if (!$this->selectedThisByMethodId($payment_method_id)) {
			return NULL; // Another method was selected, do nothing
		}

		if (!($payments = $this->getDatasByOrderId($virtuemart_order_id))) {
			// JError::raiseWarning(500, $db->getErrorMsg());
			return '';
		}

		$html = '<table class="adminlist" width="50%">' . "\n";
		$html .= $this->getHtmlHeaderBE();
		$code = "nixmoney_response_";
		$first = TRUE;
		foreach ($payments as $payment) {
			$html .= '<tr class="row1"><td>' . JText::_('VMPAYMENT_NIXMONEY_DATE') . '</td><td align="left">' . $payment->created_on . '</td></tr>';
			// Now only the first entry has this data when creating the order
			if ($first) {
				$html .= $this->getHtmlRowBE('COM_VIRTUEMART_PAYMENT_NAME', $payment->payment_name);
				// keep that test to have it backwards compatible. Old version was deleting that column  when receiving an IPN notification
				if ($payment->payment_order_total and  $payment->payment_order_total != 0.00) {
					$html .= $this->getHtmlRowBE('NIXMONEY_PAYMENT_ORDER_TOTAL', $payment->payment_order_total . " " . shopFunctions::getCurrencyByID($payment->payment_currency, 'currency_code_3'));
				}
				if ($payment->email_currency and  $payment->email_currency != 0) {
					$html .= $this->getHtmlRowBE('NIXMONEY_PAYMENT_EMAIL_CURRENCY', shopFunctions::getCurrencyByID($payment->email_currency, 'currency_code_3'));
				}
				$first = FALSE;
			}
			foreach ($payment as $key => $value) {
				// only displays if there is a value or the value is different from 0.00 and the value
				if ($value) {
					if (substr($key, 0, strlen($code)) == $code) {
						$html .= $this->getHtmlRowBE($key, $value);
					}
				}
			}

		}
		$html .= '</table>' . "\n";
		return $html;
	}


	protected function checkConditions($cart, $method, $cart_prices) {

		return true;
	}


	function plgVmOnStoreInstallPaymentPluginTable($jplugin_id) {

		return $this->onStoreInstallPluginTable($jplugin_id);
	}


	public function plgVmOnSelectCheckPayment(VirtueMartCart $cart, &$msg) {

		return $this->OnSelectCheck($cart);
	}


	public function plgVmDisplayListFEPayment(VirtueMartCart $cart, $selected = 0, &$htmlIn) {

		return $this->displayListFE($cart, $selected, $htmlIn);
	}


	/**
	 * @param VirtueMartCart $cart
	 * @param array $cart_prices
	 * @param                $cart_prices_name
	 * @return bool|null
	 */
	public function plgVmonSelectedCalculatePricePayment(VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice($cart, $cart_prices, $cart_prices_name);
	}


	function plgVmOnCheckAutomaticSelectedPayment(VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) {

		return $this->onCheckAutomaticSelected($cart, $cart_prices, $paymentCounter);
	}


	public function plgVmOnShowOrderFEPayment($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name) {

		$this->onShowOrderFE($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
	}


	function plgVmonShowOrderPrintPayment($order_number, $method_id) {

		return $this->onShowOrderPrint($order_number, $method_id);
	}


	function plgVmDeclarePluginParamsPayment($name, $id, &$data) {

		return $this->declarePluginParams('payment', $name, $id, $data);
	}

	/**
	 * @param $name
	 * @param $id
	 * @param $table
	 * @return bool
	 */
	function plgVmSetOnTablePluginParamsPayment($name, $id, &$table) {

		return $this->setOnTablePluginParams($name, $id, $table);
	}

}
