<?php
$nzshpcrt_gateways[$num]['name'] = __( 'NixMoney', 'wpsc' );
$nzshpcrt_gateways[$num]['internalname'] = 'nixmoney';
$nzshpcrt_gateways[$num]['function'] = 'gateway_nixmoney';
$nzshpcrt_gateways[$num]['form'] = "form_nixmoney";
$nzshpcrt_gateways[$num]['submit_function'] = "submit_nixmoney";
$nzshpcrt_gateways[$num]['payment_type'] = "nixmoney";
$nzshpcrt_gateways[$num]['display_name'] = __( 'NixMoney', 'wpsc' );
$nzshpcrt_gateways[$num]['image'] = WPSC_URL . '/images/nixmoney.png';

function gateway_nixmoney($separator, $sessionid)
{
	global $wpdb, $current_site;
	$purchase_log_sql = $wpdb->prepare( "SELECT * FROM `".WPSC_TABLE_PURCHASE_LOGS."` WHERE `sessionid`= %s LIMIT 1", $sessionid );
	$purchase_log = $wpdb->get_results($purchase_log_sql,ARRAY_A) ;

	$cart_sql = "SELECT * FROM `".WPSC_TABLE_CART_CONTENTS."` WHERE `purchaseid`='".$purchase_log[0]['id']."'";
	$cart = $wpdb->get_results($cart_sql,ARRAY_A) ;

	// NixMoney post variables
	$data['STATUS_URL'] = add_query_arg( 'nixmoney_callback', 'true', home_url( '/' ) );
	$data['NOPAYMENT_URL'] = home_url( '/?nixmoney_results' );
	$data['NOPAYMENT_URL_METHOD'] = "POST";
	$data['SUGGESTED_MEMO'] = $purchase_log[0]['id'];
	$data['BAGGAGE_FIELDS'] = 'SUGGESTED_MEMO';
	$data['PAYMENT_ID'] = $purchase_log[0]['id'].'-'.time();
	$data['PAYMENT_AMOUNT'] = $purchase_log[0]['id'];
	$data['PAYEE_ACCOUNT'] = get_option('nixmoney_payee');
	$data['PAYMENT_UNITS'] = get_option('nixmoney_curcode');
	$data['PAYEE_NAME'] = get_option('nixmoney_payee_name');
	$data['PAYMENT_URL'] = home_url( '/?nixmoney_results' );
	$data['PAYMENT_URL_METHOD'] = "LINK";
	$data['cs1'] = $sessionid;

	

	// Get Currency details abd price
	$local_currency_code = get_option('nixmoney_curcode');
	$nixmoney_currency_code = get_option('nixmoney_curcode');

	// NixMoney only processes in the set currency.  This is USD or EUR dependent on what the Chornopay account is set up with.
	// This must match the NixMoney settings set up in wordpress.  Convert to the nixmoney currency and calculate total.
	$curr=new CURRENCYCONVERTER();
	$decimal_places = 2;
	$total_price = 0;

	$i = 1;

	$all_donations = true;
	$all_no_shipping = true;

	foreach($cart as $item)
	{
		$product_data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `" . $wpdb->posts . "` WHERE `id`= %d LIMIT 1", $item['prodid'] ), ARRAY_A );
		$product_data = $product_data[0];
		$variation_count = count($product_variations);

		//Does this even still work in 3.8? We're not using this table.
		$variation_sql = $wpdb->prepare( "SELECT * FROM `".WPSC_TABLE_CART_ITEM_VARIATIONS."` WHERE `cart_id` = %d", $item['id'] );
		$variation_data = $wpdb->get_results( $variation_sql, ARRAY_A );
		$variation_count = count($variation_data);

		if($variation_count >= 1)
      	{
      		$variation_list = " (";
      		$j = 0;

      		foreach($variation_data as $variation)
        	{
        		if($j > 0)
          		{
          			$variation_list .= ", ";
          		}
        		$value_id = $variation['venue_id'];
        		$value_data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `".WPSC_TABLE_VARIATION_VALUES."` WHERE `id`= %d LIMIT 1", $value_id ), ARRAY_A);
        		$variation_list .= $value_data[0]['name'];
        		$j++;
        	}
      		$variation_list .= ")";
      	}
      	else
        {
        	$variation_list = '';
        }

    	$local_currency_productprice = $item['price'];

			$local_currency_shipping = $item['pnp'];


			$nixmoney_currency_productprice = $local_currency_productprice;
			$nixmoney_currency_shipping = $local_currency_shipping;

    	$data['amount_'.$i] = number_format(sprintf("%01.2f", $nixmoney_currency_productprice),$decimal_places,'.','');
    	$data['quantity_'.$i] = $item['quantity'];

		$total_price = $total_price + ($data['amount_'.$i] * $data['quantity_'.$i]);

    	$i++;
	}
  	$base_shipping = $purchase_log[0]['base_shipping'];
  	if(($base_shipping > 0) && ($all_donations == false) && ($all_no_shipping == false))
    {
		$data['handling_cart'] = number_format($base_shipping,$decimal_places,'.','');
		$total_price += number_format($base_shipping,$decimal_places,'.','');
    }

	$data['PAYMENT_AMOUNT'] = $total_price;

	// Create Form to post to NixMoney
	$output = "
		<form id=\"nixmoney_form\" name=\"nixmoney_form\" method=\"post\" action=\"https://www.nixmoney.com/merchant.jsp\">\n";

	foreach($data as $n=>$v) {
			$output .= "			<input type=\"hidden\" name=\"$n\" value=\"$v\" />\n";
	}

	$output .= "			<input type=\"submit\" value=\"Continue to NixMoney\" />
		</form>
	";

	echo($output);

	if(get_option('nixmoney_debug') == 0)
	{
		echo "<script language=\"javascript\" type=\"text/javascript\">document.getElementById('nixmoney_form').submit();</script>";
	}

  	exit();
}

function nzshpcrt_nixmoney_callback()
{
	global $wpdb;
	// needs to execute on page start
	// look at page 36

	if(isset($_GET['nixmoney_callback']) && ($_GET['nixmoney_callback'] == 'true'))
	{

		$string=
		  $_POST['PAYMENT_ID'].':'.get_option('nixmoney_payee').':'.
		  $_POST['PAYMENT_AMOUNT'].':'.$_POST['PAYMENT_UNITS'].':'.
		  $_POST['PAYMENT_BATCH_NUM'].':'.
		  $_POST['PAYER_ACCOUNT'].':'.strtoupper(md5(get_option('nixmoney_salt'))).':'.
		  $_POST['TIMESTAMPGMT'];

		echo $string;

		$hash=strtoupper(md5($string));

		if($hash == $_POST['V2_HASH'])
		{

					$sessionid = trim(stripslashes($_POST['cs1']));
					$data = array(
						'processed'  => 2,
						'transactid' => $_POST['PAYMENT_BATCH_NUM'],
						'date'       => time(),
					);
					wpsc_update_purchase_log_details( $sessionid, $data, 'sessionid' );
					transaction_results($sessionid, false, $_POST['PAYMENT_BATCH_NUM']);

					die('PAYMENT OK.');
	            	
		}
		else
		{
			die('HASH failed.');
		}

	}
}

function nzshpcrt_nixmoney_results()
{
	// Function used to translate the NixMoney returned cs1=sessionid POST variable into the recognised GET variable for the transaction results page.
	if(isset($_POST['cs1']) && ($_POST['cs1'] !='') && ($_GET['sessionid'] == ''))
	{
		$_GET['sessionid'] = $_POST['cs1'];
	}
}

function submit_nixmoney()
{
	if(isset($_POST['nixmoney_curcode']))
    {
    	update_option('nixmoney_curcode', $_POST['nixmoney_curcode']);
    }

  	if(isset($_POST['nixmoney_payee']))
    {
    	update_option('nixmoney_payee', $_POST['nixmoney_payee']);
    }

  	if(isset($_POST['nixmoney_payee_name']))
    {
    	update_option('nixmoney_payee_name', $_POST['nixmoney_payee_name']);
    }

  	if(isset($_POST['nixmoney_url']))
    {
    	update_option('nixmoney_url', $_POST['nixmoney_url']);
    }

  	if(isset($_POST['nixmoney_return_url']))
    {
    	update_option('nixmoney_return_url', $_POST['nixmoney_return_url']);
    }

  	if(isset($_POST['nixmoney_url']))
    {
    	update_option('nixmoney_url', $_POST['nixmoney_url']);
    }

 	if(isset($_POST['nixmoney_salt']))
    {
    	update_option('nixmoney_salt', $_POST['nixmoney_salt']);
    }

	return true;
}

function form_nixmoney()
{
	$select_currency[get_option('nixmoney_curcode')] = "selected='selected'";
	$nixmoney_salt = ( get_option('nixmoney_salt')=='' ? 'changeme' : get_option('nixmoney_salt') );
	$nixmoney_payee = ( get_option('nixmoney_payee')=='' ? '' : get_option('nixmoney_payee') );
	$nixmoney_return_url = ( get_option('nixmoney_return_url')=='' ? get_option('transact_url') : get_option('nixmoney_return_url') );
	$nixmoney_payee_name = ( get_option('nixmoney_payee_name')=='' ? 'WP eCommerce' : get_option('nixmoney_payee_name') );

	

	if (!isset($select_currency['USD'])) $select_currency['USD'] = '';
	if (!isset($select_currency['EUR'])) $select_currency['EUR'] = '';

	$output = "
		<tr>
			<td>" . __( 'Accepted Currency', 'wpsc' ) . "</td>
			<td>
				<select name='nixmoney_curcode'>
					<option " . $select_currency['USD'] . " value='USD'>" . __( 'USD - U.S. Dollar', 'wpsc' ) . "</option>
					<option " . $select_currency['EUR'] . " value='EUR'>" . __( 'EUR - Euros', 'wpsc' ) . "</option>
				</select>
				<p class='description'>
					" . __( 'The currency code that NixMoney will process the payment in. All products must be set up in this currency.', 'wpsc' ) . "
				</p>
		</tr>
		<tr>
			<td>" . __( 'Payee Name', 'wpsc' ) . "</td>
			<td>
				<input type='text' size='40' value='" . $nixmoney_payee_name . "' name='nixmoney_payee_name' />
		</tr>
		<tr>
			<td>" . __( 'Payee Account', 'wpsc' ) . "</td>
			<td>
				<input type='text' size='40' value='" . $nixmoney_payee . "' name='nixmoney_payee' />
				<p class='description'>
					" . __( 'Payee account ID (like U1234567)', 'wpsc' ) . "
				</p>
		</tr>
		<tr>
			<td>" . __( 'Return URL', 'wpsc' ) . "</td>
			<td>
				<input type='text' size='40' value='".$nixmoney_return_url."' name='nixmoney_return_url' />
				<p class='description'>
					" . __( 'Enter this URL in the NixMoney web client against the Product ID that you have set up. This page is the transaction details page that you have configured in Shop Options.  It can not be edited on this page.', 'wpsc' ) . "
				</p>
		</tr>
		<tr>
			<td>" . __( 'Alternate PassPhrase', 'wpsc' ) . "</td>
			<td>
				<input type='text' size='40' value='" . $nixmoney_salt . "' name='nixmoney_salt' />
				<p class='description'>
					" . __( 'Alternate PassPhrase can be found and set under Settings section in your PM account.' , 'wpsc' ) . "
				</p>
		</tr>";

	return $output;
}


add_action('init', 'nzshpcrt_nixmoney_callback');
add_action('init', 'nzshpcrt_nixmoney_results');

?>