<?php 
/*
  Plugin Name: Nixmoney
  Plugin URI: 
  Description: 
  Version: 1.0
  Author: Nixmoney
  Author URI: 
 */

if (!defined('ABSPATH'))
{
	exit;
}

add_action('plugins_loaded', 'woocommerce_nixmoney', 0);

function woocommerce_nixmoney()
{
	if (!class_exists('WC_Payment_Gateway'))
	{
		return;
	}
	
	if (class_exists('WC_NIXMONEY'))
	{
		return;
	}
		
class WC_NIXMONEY extends WC_Payment_Gateway
{
	public function __construct()
	{
		$plugin_dir = plugin_dir_url(__FILE__);

		global $woocommerce;

		$this->id = 'nixmoney';
		$this->icon = apply_filters('woocommerce_nixmoney_icon', $plugin_dir . 'nixmoney.png');
		$this->has_fields = false;

		$this->init_form_fields();
		$this->init_settings();

		$this->title = $this->get_option('title');
		$this->nixmoney_url = $this->get_option('nixmoney_url');
		$this->nixmoney_merchant = $this->get_option('nixmoney_merchant');
		$this->nixmoney_name = $this->get_option('nixmoney_name');
		$this->nixmoney_secret_key = $this->get_option('nixmoney_secret_key');
		/*
		$this->nixmoney_status_url = $this->get_option('nixmoney_status_url');
		$this->nixmoney_payment_url = $this->get_option('nixmoney_payment_url');
		$this->nixmoney_nopayment_url = $this->get_option('nixmoney_nopayment_url');
		*/
		$this->email_error = $this->get_option('email_error');
		$this->ip_filter = $this->get_option('ip_filter');
		$this->order_desc = $this->get_option('order_desc');
		$this->log_file = $this->get_option('log_file');
		$this->description = $this->get_option('description');

		add_action('woocommerce_receipt_' . $this->id, array($this, 'receipt_page'));

		add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );

		add_action('woocommerce_api_wc_' . $this->id, array($this, 'check_ipn_response'));

		if (!$this->is_valid_for_use())
		{
			$this->enabled = false;
		}
	}

	function is_valid_for_use()
	{
		return true;
	}

	public function admin_options() 
	{
		?><h3><?php _e('Nixmoney', 'woocommerce'); ?></h3>
		<p><?php _e('Настройка приема электронных платежей через Nixmoney.', 'woocommerce'); ?></p>

		<?php if ( $this->is_valid_for_use() ) : ?>
			<table class="form-table">
			<?php    	
					$this->generate_settings_html();
			?>
			</table>
				
		<?php else : ?>
			<div class="inline error"><p><strong><?php _e('Шлюз отключен', 'woocommerce'); ?></strong>: <?php _e('Nixmoney не поддерживает валюты Вашего магазина.', 'woocommerce' ); ?></p></div>
			<?php
		endif;
    }

	function init_form_fields()
	{
		$this->form_fields = array(
			'enabled' => array(
				'title' => __('Включить/Выключить', 'woocommerce'),
				'type' => 'checkbox',
				'label' => __('Включен', 'woocommerce'),
				'default' => 'yes'
			),
			'title' => array(
				'title' => __('Название', 'woocommerce'),
				'type' => 'text', 
				'description' => __( 'Это название, которое пользователь видит во время выбора способа оплаты.', 'woocommerce' ), 
				'default' => __('Nixmoney', 'woocommerce')
			),
			'nixmoney_url' => array(
				'title' => __('URL мерчанта', 'woocommerce'),
				'type' => 'text',
				'description' => __('url для оплаты в системе Nixmoney', 'woocommerce'),
				'default' => 'https://dev.nixmoney.com/merchant.jsp'
			),
			'nixmoney_name' => array(
				'title' => __('Название магазина', 'woocommerce'),
				'type' => 'text',
				'description' => __('Название магазина которое будет видимо при совершении платежа', 'woocommerce'),
				'default' => 'Оплата в магазине с помощью NixMoney'
			),
			'nixmoney_merchant' => array(
				'title' => __('Идентификатор магазина', 'woocommerce'),
				'type' => 'text',
				'description' => __('Кошелек, зарегистрированный в системе "NIXMONEY".<br/>Узнать его можно в аккаунте Nixmoney', 'woocommerce'),
				'default' => ''
			),
			'nixmoney_secret_key' => array(
				'title' => __('Секретный ключ', 'woocommerce'),
				'type' => 'password',
				'description' => __('Секретный ключ оповещения о выполнении платежа,<br/>который используется для проверки целостности полученной информации<br/>и однозначной идентификации отправителя.<br/>Должен совпадать с секретным паролем, указанным для аккаунта Nixmoney', 'woocommerce'),
				'default' => ''
			),
			'order_desc' => array(
				'title' => __('Комментарий к оплате', 'woocommerce'),
				'type' => 'text',
				'description' => __('Пояснение оплаты заказа', 'woocommerce'),
				'default' => ''
			),
			'log_file' => array(
				'title' => __('Путь до файла для журнала оплат через Nixmoney (например, /nixmoney_orders.log)', 'woocommerce'),
				'type' => 'text',
				'description' => __('Если путь не указан, то журнал не записывается', 'woocommerce'),
				'default' => ''
			),
			'ip_filter' => array(
				'title' => __('IP фильтр', 'woocommerce'),
				'type' => 'text',
				'description' => __('Список доверенных ip адресов, можно указать маску', 'woocommerce'),
				'default' => ''
			),
			'email_error' => array(
				'title' => __('Email для ошибок', 'woocommerce'),
				'type' => 'text',
				'description' => __('Email для отправки ошибок оплаты', 'woocommerce'),
				'default' => ''
			),
			'description' => array(
				'title' => __( 'Description', 'woocommerce' ),
				'type' => 'textarea',
				'description' => __( 'Описанием метода оплаты которое клиент будет видеть на вашем сайте.', 'woocommerce' ),
				'default' => 'Оплата с помощью Nixmoney'
			)
		);
	}

	function payment_fields()
	{
		if ($this->description)
		{
			echo wpautop(wptexturize($this->description));
		}
	}

	public function generate_form($order_id)
	{
		global $woocommerce;

		$order = new WC_Order($order_id);

		$m_url = $this->nixmoney_url;
		$m_name = $this->nixmoney_name;

		$out_summ = number_format($order->order_total, 2, '.', '');
		
		$nixmoney_merchant		= $this->nixmoney_merchant;
		$m_orderid	= $order_id;
		$payment_id = $m_orderid.'-'.time();
		$m_amount	= $out_summ;
		$m_curr		= get_option('woocommerce_currency');
		$m_desc		= $this->order_desc;
		$m_key		= $this->nixmoney_secret_key;
		
/*		
		$arHash = array
		(
			$m_shop,
			$m_orderid,
			$m_amount,
			$m_curr,
			$m_desc,
			$m_key
		);
		$sign = strtoupper(hash('sha256', implode(":", $arHash)));
		*/
		
		$status_url = get_site_url().'/?wc-api=wc_nixmoney&nixmoney=result';
		$redirect_url_failed = get_site_url().'/?wc-api=wc_nixmoney&nixmoney=callfalse';
		$redirect_url_ok = get_site_url().'/?wc-api=wc_nixmoney&nixmoney=calltrue';
		
		return
			'<form name="payment" action="' . $m_url . '" method="POST">
				<input type="hidden" name="PAYEE_ACCOUNT" value="'.$nixmoney_merchant.'">
				<input type="hidden" name="PAYEE_NAME" value="'.$m_name.'">
				<input type="hidden" name="PAYMENT_UNITS" value="'.$m_curr .'">
				<input type="hidden" name="STATUS_URL" value="'.$status_url.'">
				<input type="hidden" name="PAYMENT_URL" value="'.$redirect_url_ok.'">
				<input type="hidden" name="NOPAYMENT_URL" value="'.$redirect_url_failed.'">
				<input type="hidden" name="SUGGESTED_MEMO" value="'.$m_orderid.'">
				<input type="hidden" name="PAYMENT_ID" value="'.$payment_id.'">
				<input type="hidden" name="BAGGAGE_FIELDS" value="SUGGESTED_MEMO">
				<input type="hidden" name="PAYMENT_AMOUNT" value="'.$m_amount.'">
				<input type="submit" name="process" value="Оплатить" />			
			</form>';
	}
	
	function process_payment($order_id)
	{
		$order = new WC_Order($order_id);

		return array(
			'result' => 'success',
			'redirect'	=> add_query_arg('order', $order->id, add_query_arg('key', $order->order_key, get_permalink(woocommerce_get_page_id('pay'))))
		);
	}
	
	function receipt_page($order)
	{
		echo '<p>'.__('Спасибо за Ваш заказ, пожалуйста, нажмите кнопку ниже, чтобы заплатить.', 'woocommerce').'</p>';
		echo $this->generate_form($order);
	}
	
	function check_ipn_response()
	{
		global $woocommerce;
		if (isset($_GET['nixmoney']) && $_GET['nixmoney'] == 'result')
		{
			if ( isset($_POST['V2_HASH']) )
			{
				
				$string=
				 $_POST['PAYMENT_ID'].':'.$_POST['PAYEE_ACCOUNT'].':'.$_POST['PAYMENT_AMOUNT'].':'.$_POST['PAYMENT_UNITS'].':'.
				 $_POST['PAYMENT_BATCH_NUM'].':'.$_POST['PAYER_ACCOUNT'].':'.strtoupper(md5($m_key)).':'.$_POST['TIMESTAMPGMT'];
				 
				$v2key=$_POST['V2_HASH'];
				$sign_hash=strtoupper(md5($string));
				
				// проверка принадлежности ip списку доверенных ip
				$list_ip_str = str_replace(' ', '', $this->ip_filter);
				
				if (!empty($list_ip_str)) 
				{
					$list_ip = explode(',', $list_ip_str);
					$this_ip = $_SERVER['REMOTE_ADDR'];
					$this_ip_field = explode('.', $this_ip);
					$list_ip_field = array();
					$i = 0;
					$valid_ip = FALSE;
					foreach ($list_ip as $ip)
					{
						$ip_field[$i] = explode('.', $ip);
						if ((($this_ip_field[0] ==  $ip_field[$i][0]) or ($ip_field[$i][0] == '*')) and
							(($this_ip_field[1] ==  $ip_field[$i][1]) or ($ip_field[$i][1] == '*')) and
							(($this_ip_field[2] ==  $ip_field[$i][2]) or ($ip_field[$i][2] == '*')) and
							(($this_ip_field[3] ==  $ip_field[$i][3]) or ($ip_field[$i][3] == '*')))
							{
								$valid_ip = TRUE;
								break;
							}
						$i++;
					}
				}
				else
				{
					$valid_ip = TRUE;
				}
				
				$log_text = 
					"--------------------------------------------------------\n".
					"PAYMENT_ID		" . $_POST["PAYMENT_ID"] . "\n".
					"PAYEE_ACCOUNT		" . $_POST["PAYEE_ACCOUNT"] . "\n".
					"PAYMENT_AMOUNT		" . $_POST["PAYMENT_AMOUNT"] . "\n".
					"PAYMENT_UNITS	" . $_POST["PAYMENT_UNITS"] . "\n".
					"PAYMENT_BATCH_NUM	" . $_POST["PAYMENT_BATCH_NUM"] . "\n".
					"PAYER_ACCOUNT	" . $_POST["PAYER_ACCOUNT"] . "\n".
					"V2_HASH				" . $_POST["V2_HASH"] . "\n";
						
				if (!empty($this->log_file))
				{	
					file_put_contents($_SERVER['DOCUMENT_ROOT'] . $this->log_file, $log_text, FILE_APPEND);
				}
				
				$order = new WC_Order($_POST['PAYMENT_ID']);
				
				if ( $v2key == $sign_hash && $valid_ip)
				{
					$order->update_status('processing', __('Платеж успешно оплачен', 'woocommerce'));
					WC()->cart->empty_cart();
					exit ($_POST['PAYMENT_ID'] . '|success');
				}
				else
				{
					$order->update_status('failed', __('Платеж не оплачен', 'woocommerce'));

					$to = $this->email_error;
					$subject = "Ошибка оплаты";
					$message = "Не удалось провести платёж через систему Nixmoney по следующим причинам:\n\n";
					if ($v2key != $sign_hash)
					{
						$message .= " - Не совпадают цифровые подписи\n";
					}

					if (!$valid_ip)
					{
						$message .= " - ip-адрес сервера не является доверенным\n";
						$message .= "   доверенные ip: " . $this->ip_filter . "\n";
						$message .= "   ip текущего сервера: " . $_SERVER['REMOTE_ADDR'] . "\n";
					}
					$message .= "\n".$log_text;
					$headers = "From: no-reply@" . $_SERVER['HTTP_SERVER'] . "\r\nContent-type: text/plain; charset=utf-8 \r\n";
					mail($to, $subject, $message, $headers);
					exit ($_POST['PAYMENT_ID'] . '|error');
				}
			}
			else
			{
				wp_die('IPN Request Failure');
			}
		}
		else if (isset($_GET['nixmoney']) && $_GET['nixmoney'] == 'calltrue')
		{
			/*WC()->cart->empty_cart();
			$order = new WC_Order($_GET['m_orderid']);
			wp_redirect($this->get_return_url($order));*/
			echo 'Оплата произведена';
		}
		else if (isset($_GET['nixmoney']) && $_GET['nixmoney'] == 'callfalse')
		{
			/*WC()->cart->empty_cart();
			$order = new WC_Order($_GET['m_orderid']);
			wp_redirect($this->get_return_url($order));*/
			echo 'Уплата не удалась';
		}
	}
}

function add_nixmoney_gateway($methods)
{
	$methods[] = 'WC_NIXMONEY';
	return $methods;
}

add_filter('woocommerce_payment_gateways', 'add_nixmoney_gateway');
}
?>