<?php
function nixmoney_config() 
{
	$configarray = array(
		'FriendlyName' => array(
			'Type' => 'System',
			'Value' => 'Nixmoney'
		),
		'nixmoney_url' => array(
			'FriendlyName' => 'URL мерчанта (по умолчанию, https://www.nixmoney.com/merchant.jsp)',
			'Type' => 'text',
			'Size' => '20',
			'Default' => 'https://www.nixmoney.com/merchant.jsp'
		),
		'nixmoney_shop' => array(
		  'FriendlyName' => 'Кошелёк',
		  'Type' => 'text',
		  'Size' => '20'
		),
		'nixmoney_secret_key' => array(
		  'FriendlyName' => 'Секретный ключ',
		  'Type' => 'text',
		  'Size' => '20'
		),
		'nixmoney_comment' => array(
		  'FriendlyName' => 'Комментарий к оплате',
		  'Type' => 'text',
		  'Size' => '20'
		),
		'nixmoney_logfile' => array(
		  'FriendlyName' => 'Путь до файла для журнализации оплат (например, /nixmoney_orders.log)',
		  'Type' => 'text',
		  'Size' => '20'
		),
		'nixmoney_ipfilter' => array(
		  'FriendlyName' => 'IP - фильтр обработчика',
		  'Type' => 'text',
		  'Size' => '20'
		),
		'nixmoney_email_error' => array(
		  'FriendlyName' => 'Email для ошибок оплат',
		  'Type' => 'text',
		  'Size' => '20'
		)
	);

	return $configarray;
}

function nixmoney_link($params) 
{
	global $_LANG;

	if (isset($params['convertto'])) 
	{
		$params['curr'] = getCurrency(0, $params['convertto']);
	}
	
	$m_url = $params['nixmoney_url'];
	$m_shop = $params['nixmoney_shop'];
	$m_orderid = $params['invoiceid'];
	$m_amount = number_format($params['amount'], 2, '.', '');
	$m_curr = $params['curr']['code'];
	$m_desc = $params['nixmoney_comment'];
	$m_key = $params['nixmoney_secret_key'];
	
	$status_url = 'http://'. $_SERVER['HTTP_HOST'].'/modules/gateways/callback/nixmoney.php';
	$payment_url = 'http://'. $_SERVER['HTTP_HOST'].'/modules/gateways/nixmoney_success.php';
	$nopayment_url = 'http://'. $_SERVER['HTTP_HOST'].'/modules/gateways/nixmoney_fail.php';
	

	 
	$code = '
		<form id = "form_payment_nixmoney" method="POST" action="' . $m_url . '">
			
		<input type="hidden" name="PAYEE_ACCOUNT" value="' . $m_shop . '">
		<input type="hidden" name="PAYEE_NAME" value="' . $m_orderid . '">
		<input type="hidden" name="PAYMENT_UNITS" value="' . $m_curr . '">
		<input type="hidden" name="STATUS_URL" value="'.$status_url.'">
		<input type="hidden" name="PAYMENT_URL" value="'.$payment_url.'">
		<input type="hidden" name="NOPAYMENT_URL" value="'.$nopayment_url.'">
		<input type="hidden" name="SUGGESTED_MEMO" value="' . $m_desc . '">
		<input type="hidden" name="PAYMENT_ID" value="' . $m_orderid . '">
		<input type="hidden" name="PAYMENT_AMOUNT" value="' . $m_amount . '">
		<input type="submit" name="process" value="' . $_LANG['invoicespaynow'] . '" />

		</form>
		';

	return $code;
}