<?php

if (!defined('BOOTSTRAP')) 
{ 
	die('Access denied');
}

if (defined('PAYMENT_NOTIFICATION')) 
{
	$pp_response = array();
    
	if ($mode == 'notify' && !empty($_POST['V2_HASH'])) 
	{
		if (isset($_POST['PAYMENT_ID']) && isset($_POST['V2_HASH']))
		{
			$order_id = $_POST['PAYMENT_ID'];
			$order_info = fn_get_order_info($order_id);
	
			if (empty($processor_data)) 
			{
				$processor_data = fn_get_processor_data($order_info['payment_id']);
			}
	
			$m_key = $processor_data['processor_params']['m_key'];
			
			
			$string=
     $_POST['PAYMENT_ID'].':'.$_POST['PAYEE_ACCOUNT'].':'.$_POST['PAYMENT_AMOUNT'].':'.$_POST['PAYMENT_UNITS'].':'.
     $_POST['PAYMENT_BATCH_NUM'].':'.$_POST['PAYER_ACCOUNT'].':'.strtoupper(md5($m_key)).':'.$_POST['TIMESTAMPGMT'];
	 
	 	$v2key=$_POST['V2_HASH'];
		$sign_hash=strtoupper(md5($string));
			
$log_text = 
		"--------------------------------------------------------\n".
		"PAYMENT_ID		" . $_POST["PAYMENT_ID"] . "\n".
		"PAYEE_ACCOUNT		" . $_POST["PAYEE_ACCOUNT"] . "\n".
		"PAYMENT_AMOUNT		" . $_POST["PAYMENT_AMOUNT"] . "\n".
		"PAYMENT_UNITS	" . $_POST["PAYMENT_UNITS"] . "\n".
		"PAYMENT_BATCH_NUM	" . $_POST["PAYMENT_BATCH_NUM"] . "\n".
		"PAYER_ACCOUNT	" . $_POST["PAYER_ACCOUNT"] . "\n".
		"V2_HASH				" . $_POST["V2_HASH"] . "\n";
				
			if (!empty($processor_data['processor_params']['pathlog']))
			{	
				file_put_contents($_SERVER['DOCUMENT_ROOT'] . $processor_data['processor_params']['pathlog'], $log_text, FILE_APPEND);
			}
			
			// проверка принадлежности ip списку доверенных ip
			$list_ip_str = str_replace(' ', '', $processor_data['processor_params']['ipfilter']);
			
			if (!empty($list_ip_str)) 
			{
				$list_ip = explode(',', $list_ip_str);
				$this_ip = $_SERVER['REMOTE_ADDR'];
				$this_ip_field = explode('.', $this_ip);
				$list_ip_field = array();
				$i = 0;
				$valid_ip = FALSE;
				foreach ($list_ip as $ip)
				{
					$ip_field[$i] = explode('.', $ip);
					if ((($this_ip_field[0] ==  $ip_field[$i][0]) or ($ip_field[$i][0] == '*')) and
						(($this_ip_field[1] ==  $ip_field[$i][1]) or ($ip_field[$i][1] == '*')) and
						(($this_ip_field[2] ==  $ip_field[$i][2]) or ($ip_field[$i][2] == '*')) and
						(($this_ip_field[3] ==  $ip_field[$i][3]) or ($ip_field[$i][3] == '*')))
						{
							$valid_ip = TRUE;
							break;
						}
					$i++;
				}
			}
			else
			{
				$valid_ip = TRUE;
			}
			
			if ($v2key == $sign_hash && $valid_ip)
			{
				if (fn_check_payment_script('nixmoney.php', $order_id)) 
				{
					$pp_response['order_status'] = 'C';
					$pp_response['reason_text'] = __('transaction_approved');
					$pp_response['transaction_id'] = $_POST['PAYMENT_ID'];
					fn_finish_payment($order_id, $pp_response);
					exit($order_id . '|success');
				}
				else
				{
					$pp_response['order_status'] = 'D';
					$pp_response['reason_text'] = __('text_transaction_declined');
					$pp_response['transaction_id'] = $_POST['PAYMENT_ID'];
					fn_finish_payment($order_id, $pp_response);
					exit($order_id . '|error');
				}
			}
			else
			{
				$pp_response['order_status'] = 'D';
				$pp_response['reason_text'] = __('text_transaction_declined');
				$pp_response['transaction_id'] = $_POST['PAYMENT_ID'];
				fn_finish_payment($order_id, $pp_response);
				
				$to = $processor_data['processor_params']['emailerr'];
				$subject = __("nixmoney_mail_subject");
				$message = __("nixmoney_mail_msg1") . ":\n\n";
				
				if ($_POST["V2_HASH"] != $sign_hash)
				{
					$message .= __("nixmoney_mail_msg2") . "\n";
				}
				
				if (!$valid_ip)
				{
					$message .= __("nixmoney_mail_msg4") . "\n";
					$message .= __("nixmoney_mail_msg5") . $processor_data['processor_params']['ipfilter'] . "\n";
					$message .= __("nixmoney_mail_msg6") . $_SERVER['REMOTE_ADDR'] . "\n";
				}
				
				$message .= "\n" . $log_text;
				$headers = "From: no-reply@" . $_SERVER['HTTP_SERVER'] . "\r\nContent-type: text/plain; charset=utf-8 \r\n";
				mail($to, $subject, $message, $headers);
	
				exit($order_id . '|error');
			}
		}
	}

    if ($mode == 'success' && !empty($_GET['m_orderid'])) 
	{
		if ($_GET['m_status'] == 'success') 
		{
			$pp_response['order_status'] = 'P';
			$pp_response['reason_text'] = __('transaction_approved');
			$pp_response['transaction_id'] = $_GET['m_operation_id'];
		}
	}
	elseif ($mode == 'fail' && !empty($_GET['m_orderid'])) 
	{
		if ($_GET['m_status'] == 'fail') 
		{
			$pp_response['order_status'] = 'F';
			$pp_response['reason_text'] = __('text_transaction_declined');
		}
	}
	
	$order_id = (int)$_GET['m_orderid'];
	$order_info = fn_get_order_info($order_id);
			
	if ($order_info['status'] == 'C' || $order_info['status'] == 'D')
	{
		$pp_response['order_status'] = $order_info['status'];
		fn_order_placement_routines('route', $order_id);
	}
	elseif (fn_check_payment_script('nixmoney.php', $order_id)) 
	{
		fn_order_placement_routines('route', $order_id);
        fn_finish_payment($order_id, $pp_response);
    }
} 
else 
{
	$payment_url = $processor_data['processor_params']['m_url'];
	$m_shop = $processor_data['processor_params']['m_shop'];
	$m_orderid = $order_id;
	$m_amount = fn_format_price($order_info['total'], $processor_data['processor_params']['currency']);
	$m_amount = number_format($m_amount, 2, '.', '');
	$m_curr = $processor_data['processor_params']['currency'];
	$m_desc = $processor_data['processor_params']['m_desc'];
	$m_key = $processor_data['processor_params']['m_key'];
	$m_status_url = 'http://'. $_SERVER['HTTP_HOST'].'/?dispatch=payment_notification.notify&payment=nixmoney';
	$m_payment_url = 'http://'. $_SERVER['HTTP_HOST'].'/?dispatch=payment_notification.success&payment=nixmoney';
	$m_nopayment_url = 'http://'. $_SERVER['HTTP_HOST'].'/?dispatch=payment_notification.fail&payment=nixmoney';

	$m_orderid2 = time().$m_orderid;
	
	$post_data = array(
		'PAYEE_ACCOUNT' => $m_shop,
		'PAYEE_NAME' => $m_desc,
		'STATUS_URL' => $m_status_url,
		'PAYMENT_URL' => $m_payment_url,
		'NOPAYMENT_URL' => $m_nopayment_url,
		'PAYMENT_AMOUNT' => $m_amount,
		'PAYMENT_UNITS' => $m_curr,
		'SUGGESTED_MEMO' => $m_orderid,
		'BAGGAGE_FIELDS' => 'SUGGESTED_MEMO',
		'PAYMENT_ID' => $m_orderid2
	);

	fn_create_payment_form($payment_url, $post_data, 'Nixmoney', false);
}
exit;