<?php

require_once('api/Simpla.php');

class nixmoney extends Simpla
{	
	public function checkout_form($order_id, $button_text = null)
	{
		if(empty($button_text))
			$button_text = 'Go to payment';
		
		$order = $this->orders->get_order((int)$order_id);
		$payment_method = $this->payment->get_payment_method($order->payment_method_id);
		$payment_currency = $this->money->get_currency(intval($payment_method->currency_id));
		$settings = $this->payment->get_payment_settings($payment_method->id);
		
		$price = round($this->money->convert($order->total_price, $payment_method->currency_id, false), 2);
		
		
		// описание заказа
		$desc = 'Order #'.$order->id;
		if($settings['nixmoney_payee_account'][0]=='U') $p_currency='USD';
		elseif($settings['nixmoney_payee_account'][0]=='E') $p_currency='EUR';
		$redirect_url_ok = $this->config->root_url.'/order/'.$order->url;
		$redirect_url_failed = $this->config->root_url.'/order/'.$order->url;
		$status_url = $this->config->root_url.'/payment/nixmoney/callback.php';

	$button = '<form name="payment" action="https://www.nixmoney.com/merchant.jsp" method="POST">
<input type="hidden" name="PAYEE_ACCOUNT" value="'.$settings['nixmoney_payee_account'].'">
<input type="hidden" name="PAYEE_NAME" value="'.$settings['nixmoney_payee_name'].'">
<input type="hidden" name="PAYMENT_UNITS" value="'.$p_currency.'">
<input type="hidden" name="STATUS_URL" value="'.$status_url.'">
<input type="hidden" name="PAYMENT_URL" value="'.$redirect_url_ok.'">
<input type="hidden" name="PAYMENT_URL_METHOD" value="LINK">
<input type="hidden" name="NOPAYMENT_URL" value="'.$redirect_url_failed.'">
<input type="hidden" name="NOPAYMENT_URL_METHOD" value="LINK">
<input type="hidden" name="SUGGESTED_MEMO" value="'.$order->id.'">
<input type="hidden" name="PAYMENT_ID" value="'.time().$order->id.'">
<input type="hidden" name="PAYMENT_AMOUNT" value="'.$price.'">
<input type="hidden" name="BAGGAGE_FIELDS" value="SUGGESTED_MEMO">
<input type="submit" name="process" value="'.$button_text.'" class="checkout_button">
</form>';
		return $button;
	}
}